--[[
Copyright (C) GtX (Andy), 2025

Author: GtX | Andy
Date: 27.04.2025
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

PlaceableCustomFieldAnswerEvent = {}

local PlaceableCustomFieldAnswerEvent_mt = Class(PlaceableCustomFieldAnswerEvent, Event)
InitEventClass(PlaceableCustomFieldAnswerEvent, "PlaceableCustomFieldAnswerEvent")

function PlaceableCustomFieldAnswerEvent.emptyNew()
    return Event.new(PlaceableCustomFieldAnswerEvent_mt, NetworkNode.CHANNEL_MAIN)
end

function PlaceableCustomFieldAnswerEvent.new(placeable, buildStatusCode)
    local self = PlaceableCustomFieldAnswerEvent.emptyNew()

    self.placeable = placeable
    self.buildStatusCode = buildStatusCode

    return self
end

function PlaceableCustomFieldAnswerEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self.buildStatusCode = streamReadUInt8(streamId)

    self:run(connection)
end

function PlaceableCustomFieldAnswerEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUInt8(streamId, self.buildStatusCode)
end

function PlaceableCustomFieldAnswerEvent:run(connection)
    if self.placeable ~= nil and self.placeable:getIsSynchronized() then
        g_messageCenter:publish(PlaceableCustomFieldAnswerEvent, self.buildStatusCode)
    end
end
