--[[
Part of Production Supply Trader FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]


function productionSupplyTrader.registerXMLPaths(schema, basePath)
	schema:register(XMLValueType.BOOL, basePath .. ".storage.capacity(?)#allowBuying", "Allow buying Filltype from Production Menu", false)
	schema:register(XMLValueType.BOOL, basePath .. ".storage.capacity(?)#allowSelling", "Allow manually selling Filltype from Production Menu", false)
end

ProductionPoint.registerXMLPaths = Utils.prependedFunction(ProductionPoint.registerXMLPaths, productionSupplyTrader.registerXMLPaths)



function productionSupplyTrader:load(superFunc, components, xmlFile, key, customEnv, i3dMappings)
	local success = superFunc(self, components, xmlFile, key, customEnv, i3dMappings)
	self.allowFillTypeIdsBuying = {}
	self.allowFillTypeIdsSelling = {}

	--Auslesen ob ein FillType manuell gekauft/verkauf werden darf
	xmlFile:iterate(key..".storage.capacity", function(storageIndex, storageKey)
		local fillType = xmlFile:getValue(storageKey .. "#fillType")
		local storageType = g_fillTypeManager:getFillTypeIndexByName(fillType)
		if storageType ~= nil then
			local allowBuying = xmlFile:getValue(storageKey .. "#allowBuying", true)
			local allowSelling = xmlFile:getValue(storageKey .. "#allowSelling", true)
			if allowBuying == false then
				self.allowFillTypeIdsBuying[storageType] = true
			end
			if allowSelling == false then
				self.allowFillTypeIdsSelling[storageType] = false
			end
		end
	end)

	return success
end

ProductionPoint.load = Utils.overwrittenFunction(ProductionPoint.load, productionSupplyTrader.load)