--[[
Simply allow placement of buildings on any land, regardless of ownership or permissions.

Author:     w33zl (https://github.com/w33zl)
Version:    1.0.0
Modified:   2025-05-11

Changelog:

]]

ConstructionBrush.verifyAccess = Utils.overwrittenFunction(ConstructionBrush.verifyAccess, function (self, superFunc, ...)
    -- Log:debug("UnrestrictedPlacement: ConstructionBrush:verifyAccess() called")
    local returnValue = superFunc(self, ...)

    if returnValue == ConstructionBrush.ERROR.LAND_UNOWNED then
        returnValue = nil
    end
    
    return returnValue
end)

ConstructionBrushPlaceable.verifyPlacement = Utils.overwrittenFunction(ConstructionBrushPlaceable.verifyPlacement, function (self, superFunc, ...)
    -- Log:debug("UnrestrictedPlacement: ConstructionBrushPlaceable:verifyPlacement() called")

    local storedGetIsOnOwnedFarmland = self.placeable.getIsOnOwnedFarmland
    self.placeable.getIsOnOwnedFarmland = nil

    local returnValue = superFunc(self, ...)

    self.placeable.getIsOnOwnedFarmland = storedGetIsOnOwnedFarmland

    -- Log:var("ConstructionBrushPlaceable returnValue", returnValue)

    return returnValue
end)
